﻿<%@ Page language="c#" codePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Import Namespace="Soneta.Kasa" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Pełny raport kasowy</title>
		<script runat="server">

	class Element: IComparable {
		readonly string nazwa;
		decimal wpłaty;
		decimal wypłaty;
		public Element(Zaplata z) {
			this.nazwa = z.SposobZaplaty.ToString();
		}
		public void Add(Zaplata z) {
			wpłaty += z.Wpłata.Value;
			wypłaty += z.Wypłata.Value;
		}
		public int CompareTo(object v) {
			return string.Compare(Nazwa, ((Element)v).Nazwa, true);
		}
		public string Nazwa { 
			get { return nazwa; } 
		}		
		public decimal Wpłata { 
			get { return wpłaty; } 
		}
		public decimal Wypłata { 
			get { return wypłaty; } 
		}
	}
	
	class Element2 {
		readonly string nazwa;
		object wpłaty;
		object wypłaty;
		static string marker = "--------------";
		public Element2(string nazwa, object wpłaty, object wypłaty) {
			this.nazwa = nazwa;
			this.wpłaty = wpłaty;
			this.wypłaty = wypłaty;
		}
		public string Nazwa { 
			get { return nazwa; } 
		}		
		public object Wpłata { 
			get { return wpłaty!=null ? wpłaty : marker; } 
		}
		public object Wypłata { 
			get { return wypłaty!=null ? wypłaty : marker; } 
		}
	}
	
	Hashtable elements = new Hashtable();
	decimal sumWpł = 0;
	decimal sumWypł = 0;
	
    void Grid1_BeforeRow(Object sender, RowEventArgs args) {
		Zaplata z = (Zaplata)args.Row;
		if (z.NumeryDokumentow=="")
			opis.EditValue = z.Opis;
		else 
			opis.EditValue = z.Opis + "<br>Za: " + z.NumeryDokumentow;
			
		Element elem = (Element)elements[z.SposobZaplaty];
		if (elem==null) {
			elem = new Element(z);
			elements[z.SposobZaplaty] = elem;
		}
		elem.Add(z);		
		
		sumWpł += z.Wpłata.Value;
		sumWypł += z.Wypłata.Value;
    }
    
    void Grid1_AfterRender(Object sender, EventArgs args) {
        RaportESP raport = (RaportESP)dc[typeof(RaportESP)];
		ArrayList arr = new ArrayList(elements.Values);
		arr.Sort();
		Grid2.DataSource = arr;
		
		Element2[] els = new Element2[3];
		els[0] = new Element2("Obroty", sumWpł, sumWypł);
		els[1] = new Element2("Stan poprzedni", GT(raport.SaldoPoczatkowe.Value), LT(raport.SaldoPoczatkowe.Value));
		els[2] = new Element2("Stan obecny", LT(raport.SaldoKoncowe.Value), GT(raport.SaldoKoncowe.Value));
		
		Grid3.DataSource = els;
	}
	
	object GT(decimal value) {
		if (value>0)
			return value;
		return null;
	}
	
	object LT(decimal value) {
		if (value<0)
			return -value;
		return null;
	}

		</script>
		
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="PełnyRaportKasowy" method="post" runat="server">
			<P><ea:datacontext id="dc" runat="server" TypeName="Soneta.Kasa.RaportESP, Soneta.Kasa"></ea:datacontext><ea:sectionmarker id="SectionMarker1" runat="server" SectionType="Header"></ea:sectionmarker>
				<TABLE id="Table1" cellSpacing="0" width="100%" border="0">
					<TR>
						<TD width="40%">
							<P><ea:datalabel id="Datalabel7" runat="server" DataMember="Core.Config.Firma.Pieczątka.Nazwa" ContextTypeName="Soneta.Business.Session,Soneta.Business"></ea:datalabel></P>
						</TD>
						<TD align="middle" width="50%">
							<H4>RAPORT KASOWY
								<TABLE id="Table2" cellSpacing="0" cellPadding="0" width="100%" border="0">
									<TR>
										<TD width="40%">Ewidencja:</TD>
										<TD><ea:datalabel id="DataLabel1" runat="server" DataMember="Kasa" DESIGNTIMEDRAGDROP="25"></ea:datalabel></TD>
									</TR>
									<TR>
										<TD>Waluta:</TD>
										<TD><ea:datalabel id="DataLabel5" runat="server" DataMember="Kasa.Waluta.Symbol"></ea:datalabel></TD>
									</TR>
									<TR>
										<TD>Numer:</TD>
										<TD><ea:datalabel id="DataLabel2" runat="server" DataMember="Numer"></ea:datalabel></TD>
									</TR>
									<TR>
										<TD>Okres:</TD>
										<TD><ea:datalabel id="DataLabel3" runat="server" DataMember="Okres.From" DESIGNTIMEDRAGDROP="184"></ea:datalabel>...
											<ea:datalabel id="DataLabel4" runat="server" DataMember="Okres.To"></ea:datalabel></TD>
									</TR>
									<TR>
										<TD>Stan:</TD>
										<TD><STRONG>Zamknięty/Otwarty</STRONG></TD>
									</TR>
								</TABLE>
							</H4>
						</TD>
					</TR>
				</TABLE>
			</P>
			<P>
				<ea:sectionmarker id="SectionMarker2" runat="server"></ea:sectionmarker><ea:grid id="Grid1" runat="server" DataMember="Zaplaty" OnAfterRender="Grid1_AfterRender" RowTypeName="Soneta.Kasa.Zaplata, Soneta.Kasa, Version=1.0.1118.12462, Culture=neutral, PublicKeyToken=null" OnBeforeRow="Grid1_BeforeRow" RowsInRow="2">
					<Columns>
						<ea:GridColumn Width="4" Align="Right" DataMember="Lp" Caption="LP." ID="lp" RowSpan="2"></ea:GridColumn>
						<ea:GridColumn Width="10" DataMember="DataDokumentu" Caption="Data" ID="data"></ea:GridColumn>
						<ea:GridColumn ColSpan="4" ID="opis"></ea:GridColumn>
						<ea:GridColumn Width="20" DataMember="NumerDokumentu" Caption="Numer" ID="numer"></ea:GridColumn>
						<ea:GridColumn Width="36" DataMember="Podmiot" Caption="Dla kogo/Komu" ID="podmiot"></ea:GridColumn>
						<ea:GridColumn Width="8" DataMember="SposobZaplaty" Caption="Forma" ID="płatność"></ea:GridColumn>
						<ea:GridColumn Width="15" Align="Right" DataMember="Wpłata.Value" Total="Sum" Caption="Wpłata" Format="{0:n}" ID="Wpłata" RowSpan="2"></ea:GridColumn>
						<ea:GridColumn Width="15" Align="Right" DataMember="Wypłata.Value" Total="Sum" Caption="Wypłata" Format="{0:n}" ID="wypłata" RowSpan="2"></ea:GridColumn>
					</Columns>
				</ea:grid>
			</P>
			<P>
				<TABLE id="Table3" width="100%">
					<TR>
						<TD vAlign="top" width="50%"><ea:grid id="Grid2" runat="server">
								<Columns>
									<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="LP." ID="lp2"></ea:GridColumn>
									<ea:GridColumn Width="8" DataMember="Nazwa" Caption="Forma" ID="płatność2"></ea:GridColumn>
									<ea:GridColumn Width="15" Align="Right" DataMember="Wpłata" Total="Sum" Caption="Wpłata" Format="{0:n}" ID="wpłata2"></ea:GridColumn>
									<ea:GridColumn Width="15" Align="Right" DataMember="Wypłata" Total="Sum" Caption="Wypłata" Format="{0:n}" ID="wypłata2"></ea:GridColumn>
								</Columns>
							</ea:grid></TD>
						<TD vAlign="top" width="50%"><ea:grid id="Grid3" runat="server">
								<Columns>
									<ea:GridColumn Width="20" DataMember="Nazwa" Total="Info" ID="pozycja3"></ea:GridColumn>
									<ea:GridColumn Width="15" Align="Right" DataMember="Wpłata" Total="Sum" Caption="Wpłata" Format="{0:n}" ID="wpłata3"></ea:GridColumn>
									<ea:GridColumn Width="15" Align="Right" DataMember="Wypłata" Total="Sum" Caption="Wypłata" Format="{0:n}" ID="wypłata3"></ea:GridColumn>
								</Columns>
							</ea:grid></TD>
					</TR>
				</TABLE>
			</P>
			<ea:sectionmarker id="SectionMarker3" runat="server" SectionType="LastFooter"></ea:sectionmarker><BR>
			<ea:datalabel id="Datalabel6" runat="server" DataMember="Core.Config.Firma.Pieczątka.NazwaSkrócona" DESIGNTIMEDRAGDROP="66" ContextTypeName="Soneta.Business.Session,Soneta.Business"></ea:datalabel>, 
			enova365 sn.: <STRONG>XXXX-XXXX-XXXX-XXXX</STRONG>
		</form>
	</body>
</HTML>

